function [residual, g1, g2, g3] = World_Economy_Cartel_VD_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 66, 1);

%
% Model equations
%

T18 = exp(y(19))-params(9)*exp(y(18))^(1+params(8))/(1+params(8));
T21 = T18^(-params(14));
T33 = params(21)^(-1);
T50 = exp(y(1))*y(35)+T33*y(43)*(-(exp(y(22))*exp(y(1))*exp(y(11))))+T33*y(46)*(-(exp(y(1))*exp(y(22))));
T64 = exp(y(2))/(exp(y(2))+exp(y(3)));
T73 = params(12)^(1-params(4));
T92 = exp(y(3))/(exp(y(2))+exp(y(3)));
T99 = params(13)^(1-params(4));
T137 = exp(y(1))*exp(y(4))-exp(y(4))*params(6)*exp(y(31)-y(24))^(params(5)-1);
T143 = exp(y(4))/(exp(y(4))+exp(y(5)));
T163 = exp(y(5))/(exp(y(4))+exp(y(5)));
T208 = exp(y(6))*y(48)+params(21)*y(39)*exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))+params(21)*y(48)*(-(exp(y(6))*(1-exp((-y(24)))*exp(y(10)))))+params(21)*y(52)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
T231 = exp(y(7))*y(47)+params(21)*y(39)*exp(y(7))*params(6)*exp(y(11)*params(5))+params(21)*y(47)*(-(exp(y(7))*(1-exp(y(11)))))+params(21)*y(51)*(-(exp(y(11))*exp(y(7))));
T272 = params(21)*y(52)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))))+params(21)*y(39)*exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(24)))+params(21)*y(48)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))));
T294 = (-(exp(y(22))*(exp(y(1))*exp(y(11))+y(13)*(-exp(y(11)))-params(6)*params(5)*exp(y(11)*params(5)))));
T295 = y(43)*T294;
T344 = exp(y(16))^(1/params(2));
T346 = (-1)/params(2);
T348 = exp(y(15))*getPowerDeriv(exp(y(15)),T346,1);
T354 = (params(2)-1)/params(2);
T356 = exp(y(15))*getPowerDeriv(exp(y(15)),T354,1);
T366 = exp(y(17))^params(3);
T368 = exp(y(18))^(1-params(3));
T369 = T366*T368;
T370 = T369^T354;
T374 = (1-params(11))*exp(T354*y(23))*T370+params(11)*exp(y(15))^T354;
T376 = getPowerDeriv(T374,params(2)/(params(2)-1),1);
T389 = exp(y(17))^(params(3)-1);
T390 = T369^T346;
T394 = exp(y(16))*getPowerDeriv(exp(y(16)),1/params(2),1);
T403 = exp(y(18))^(-params(3));
T412 = exp(y(15))^T346;
T428 = exp(y(17))*getPowerDeriv(exp(y(17)),params(3),1);
T430 = getPowerDeriv(T369,T354,1);
T432 = (1-params(11))*exp(T354*y(23))*T368*T428*T430;
T437 = T344*exp(T354*y(23))*(1-params(11))*(1-params(3));
T440 = getPowerDeriv(T369,T346,1);
T441 = T368*T428*T440;
T444 = T428*T390*T437+T366*T437*T441;
T450 = T344*exp(T354*y(23))*(1-params(11))*params(3);
T455 = exp(y(17))*getPowerDeriv(exp(y(17)),params(3)-1,1);
T459 = (-(T368*(T389*T441*T450+T390*T450*T455)));
T485 = exp(y(18))*getPowerDeriv(exp(y(18)),1+params(8),1);
T488 = (-(params(9)*T485/(1+params(8))));
T489 = getPowerDeriv(T18,(-params(14)),1);
T490 = T488*T489;
T503 = (-(exp(T354*y(23))*exp(y(17)*params(3))*(1-params(3))*exp(y(18)*(1-params(3)))));
T507 = exp(y(18))*getPowerDeriv(exp(y(18)),1-params(3),1);
T522 = exp(y(18))*getPowerDeriv(exp(y(18)),(-params(3)),1);
T528 = (1-params(11))*exp(T354*y(23))*T430*T366*T507;
T576 = params(9)^((-1)/params(8));
T581 = exp(y(21))*getPowerDeriv(exp(y(21)),1/params(8),1);
T592 = exp(y(22))*params(6)*params(5)*exp(y(11)*(params(5)-1))-exp(y(22))*(exp(y(1))-y(13));
T607 = (-(exp(y(22))*(exp(y(1))*exp(y(11))+(1-exp(y(11)))*y(13)-params(6)*exp(y(11)*params(5)))));
T616 = T33*y(46)*T592+exp(y(22))*y(42)+T33*y(41)*(-(exp(y(22))*(1+exp(y(20))-params(10))))+T33*y(43)*T607+T33*y(44)*(-(y(14)*exp(y(22))*(1-params(7))));
T643 = T370*(1-params(11))*T354*exp(T354*y(23));
T650 = params(21)^2;
T661 = getPowerDeriv(exp(y(31)-y(24)),params(5)-1,1);
T683 = y(52)*(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))))+y(48)*(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))))+y(39)*exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))*(-params(5));
residual(1) = T21*exp(y(1))*exp(y(4))+(-y(57))+T50+y(57)*params(21);
residual(2) = T21*(-exp(y(2)))+y(63)*(-T64)+(-y(59))+y(50)*(-(T73*params(4)*exp(y(2)*params(4))))+exp(y(2))*y(39)+params(21)*y(59)+params(21)*y(63)*T64;
residual(3) = y(63)*(-T92)+(-y(58))+y(49)*(-(T99*params(4)*exp(y(3)*params(4))))+y(45)*y(14)*T99*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1))+exp(y(3))*y(39)+params(21)*y(58)+params(21)*y(63)*T92;
residual(4) = T21*T137+y(64)*(-T143)+(-y(61))+y(53)*(-exp(y(4)))+exp(y(4))*y(52)+params(21)*y(61)+params(21)*y(64)*T143;
residual(5) = y(64)*(-T163)+(-y(60))+y(53)*(-exp(y(5)))+exp(y(5))*y(51)+params(21)*y(60)+params(21)*y(64)*T163;
residual(6) = T208;
residual(7) = T231;
residual(8) = y(50)*exp(y(8))+y(48)*(-(exp(y(8))*params(7)))+params(21)*y(50)*(-(exp(y(8))*(1-params(7))));
residual(9) = y(49)*exp(y(9))+y(47)*(-(params(7)*exp(y(9))))+params(21)*y(49)*(-((1-params(7))*exp(y(9))));
residual(10) = T272+params(21)*y(56)*(-exp(y(10)));
residual(11) = params(21)*y(51)*(-(exp(y(11))*exp(y(7))))+y(46)*exp(y(22))*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T295+params(21)*y(39)*exp(y(7))*params(6)*params(5)*exp(y(11)*params(5))+params(21)*y(47)*(-(exp(y(7))*(-exp(y(11)))));
residual(12) = exp(y(12))*y(38);
residual(13) = y(44)*(-params(7))+y(43)+T33*y(43)*(-(exp(y(22))*(1-exp(y(11)))))+T33*exp(y(22))*y(46);
residual(14) = y(45)*T99*params(4)*exp(y(3)*(params(4)-1))+y(44)+T33*y(44)*(-(exp(y(22))*(1-params(7))));
residual(15) = y(53)*exp(y(15))+y(35)*(-(params(11)*T344*T348))+y(34)*(-(params(11)*T356*T376));
residual(16) = (-y(62))+y(39)*(-exp(y(16)))+y(37)*(-(T368*T389*T390*exp(T354*y(23))*(1-params(11))*params(3)*T394))+y(36)*(-(T403*T366*T390*T394*exp(T354*y(23))*(1-params(11))*(1-params(3))))+y(35)*(-(T412*params(11)*T394))+exp(y(16))*y(34)+params(21)*y(62);
residual(17) = y(39)*exp(y(17))+params(21)*y(34)*(-(T376*T432))+params(21)*y(36)*(-(T403*T444))+params(21)*y(37)*T459+params(21)*y(38)*(-(exp(y(18)*(1-params(3)))*exp(T354*y(23))*params(3)*exp(y(17)*params(3))))+params(21)*y(39)*(-(exp(y(17))*(1-params(10))));
residual(18) = (T137-exp(y(2)))*T490+y(42)*(-(T490*params(1)/T21))+exp(y(18))*y(40)+y(38)*T503+y(37)*(-(T389*T390*T450*T507+T368*T389*T450*T440*T366*T507))+y(36)*(-(T403*T366*T437*T440*T366*T507+T366*T390*T437*T522))+y(34)*(-(T376*T528))+params(21)*y(42)*(-((-(T490*T21*params(1)))/(T21*T21)));
residual(19) = (T137-exp(y(2)))*exp(y(19))*T489+y(42)*(-(params(1)*exp(y(19))*T489/T21))+exp(y(19))*y(39)+params(21)*y(42)*(-((-(T21*params(1)*exp(y(19))*T489))/(T21*T21)));
residual(20) = y(37)*exp(y(20))+T33*y(41)*(-(exp(y(22))*exp(y(20))));
residual(21) = y(40)*(-(T576*T581))+y(36)*exp(y(21));
residual(22) = T616;
residual(23) = y(55)+params(21)*y(55)*(-params(15))+y(38)*(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T354*exp(T354*y(23))))+y(37)*(-(T368*T389*T390*T344*(1-params(11))*params(3)*T354*exp(T354*y(23))))+y(36)*(-(T403*T366*T390*T344*(1-params(11))*(1-params(3))*T354*exp(T354*y(23))))+y(34)*(-(T376*T643))+T650*y(55)*(-params(16));
residual(24) = T21*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T661))+y(54)+T683;
residual(25) = y(57);
residual(26) = y(58);
residual(27) = y(59);
residual(28) = y(60);
residual(29) = y(61);
residual(30) = y(62);
residual(31) = T21*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T661))+y(56)*exp(y(31));
residual(32) = y(63);
residual(33) = y(64);
residual(34) = exp(y(16))-T374^(params(2)/(params(2)-1));
residual(35) = exp(y(1))-params(11)*T344*T412;
residual(36) = exp(y(21))-T403*T366*T390*T437;
residual(37) = exp(y(20))-T368*T389*T390*T450;
residual(38) = exp(y(12))-exp(y(18)*(1-params(3)))*exp(T354*y(23))*exp(y(17)*params(3));
residual(39) = exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))+exp(y(7))*params(6)*exp(y(11)*params(5))+exp(y(2))+exp(y(3))+exp(y(19))+exp(y(17))-(exp(y(16))+exp(y(17))*(1-params(10)));
residual(40) = exp(y(18))-T576*exp(y(21))^(1/params(8));
residual(41) = 1-exp(y(22))*(1+exp(y(20))-params(10));
residual(42) = exp(y(22))-T21*params(1)/T21;
residual(43) = y(13)-exp(y(22))*(exp(y(1))*exp(y(11))+(1-exp(y(11)))*y(13)-params(6)*exp(y(11)*params(5)));
residual(44) = y(14)-(y(14)*exp(y(22))*(1-params(7))+params(7)*y(13));
residual(45) = y(14)*T99*params(4)*exp(y(3)*(params(4)-1))-1;
residual(46) = T592;
residual(47) = exp(y(7))-(exp(y(7))*(1-exp(y(11)))+params(7)*exp(y(9)));
residual(48) = exp(y(6))-(exp(y(6))*(1-exp((-y(24)))*exp(y(10)))+exp(y(8))*params(7));
residual(49) = exp(y(9))-((1-params(7))*exp(y(9))+T99*exp(y(3)*params(4)));
residual(50) = exp(y(8))-(exp(y(8))*(1-params(7))+T73*exp(y(2)*params(4)));
residual(51) = exp(y(5))-exp(y(11))*exp(y(7));
residual(52) = exp(y(4))-exp(y(6))*exp((-y(24)))*exp(y(10));
residual(53) = exp(y(15))-(exp(y(4))+exp(y(5)));
residual(54) = y(24)-x(1);
residual(55) = y(23)-(x(2)+y(23)*params(15)+y(23)*params(16));
residual(56) = exp(y(31))-exp(y(10));
residual(57) = y(25);
residual(58) = y(26);
residual(59) = y(27);
residual(60) = y(28);
residual(61) = y(29);
residual(62) = y(30);
residual(63) = y(32);
residual(64) = y(33);
lhs =y(65);
rhs =y(55);
residual(65)= lhs-rhs;
lhs =y(66);
rhs =y(23);
residual(66)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(66, 66);

  %
  % Jacobian matrix
  %

T829 = (exp(y(2))*(exp(y(2))+exp(y(3)))-exp(y(2))*exp(y(2)))/((exp(y(2))+exp(y(3)))*(exp(y(2))+exp(y(3))));
T844 = (-(exp(y(2))*exp(y(3))))/((exp(y(2))+exp(y(3)))*(exp(y(2))+exp(y(3))));
T855 = (exp(y(3))*(exp(y(2))+exp(y(3)))-exp(y(3))*exp(y(3)))/((exp(y(2))+exp(y(3)))*(exp(y(2))+exp(y(3))));
T878 = (exp(y(4))*(exp(y(4))+exp(y(5)))-exp(y(4))*exp(y(4)))/((exp(y(4))+exp(y(5)))*(exp(y(4))+exp(y(5))));
T888 = (-(exp(y(4))*exp(y(5))))/((exp(y(4))+exp(y(5)))*(exp(y(4))+exp(y(5))));
T899 = (exp(y(5))*(exp(y(4))+exp(y(5)))-exp(y(5))*exp(y(5)))/((exp(y(4))+exp(y(5)))*(exp(y(4))+exp(y(5))));
T908 = params(21)*y(51)*(-(exp(y(11))*exp(y(7))))+params(21)*y(39)*exp(y(7))*params(6)*params(5)*exp(y(11)*params(5))+params(21)*y(47)*(-(exp(y(7))*(-exp(y(11)))));
T966 = getPowerDeriv(T374,params(2)/(params(2)-1),2);
T991 = T394+exp(y(16))*exp(y(16))*getPowerDeriv(exp(y(16)),1/params(2),2);
T1018 = y(36)*(-(T403*(T390*T394*exp(T354*y(23))*(1-params(11))*(1-params(3))*T428+T366*T394*exp(T354*y(23))*(1-params(11))*(1-params(3))*T441)));
T1026 = y(37)*(-(T368*(T389*exp(T354*y(23))*(1-params(11))*params(3)*T394*T441+T390*exp(T354*y(23))*(1-params(11))*params(3)*T394*T455)));
T1043 = y(37)*(-(T389*T390*exp(T354*y(23))*(1-params(11))*params(3)*T394*T507+T368*T389*exp(T354*y(23))*(1-params(11))*params(3)*T394*T440*T366*T507))+y(36)*(-(T403*T366*T394*exp(T354*y(23))*(1-params(11))*(1-params(3))*T440*T366*T507+T366*T390*T394*exp(T354*y(23))*(1-params(11))*(1-params(3))*T522));
T1056 = y(37)*(-(T368*T389*T390*T394*(1-params(11))*params(3)*T354*exp(T354*y(23))))+y(36)*(-(T403*T366*T390*T394*(1-params(11))*(1-params(3))*T354*exp(T354*y(23))));
T1065 = T428+exp(y(17))*exp(y(17))*getPowerDeriv(exp(y(17)),params(3),2);
T1067 = getPowerDeriv(T369,T354,2);
T1082 = getPowerDeriv(T369,T346,2);
T1086 = T440*T368*T1065+T368*T428*T368*T428*T1082;
T1168 = y(37)*(-(T368*(T455*T390*T344*(1-params(11))*params(3)*T354*exp(T354*y(23))+T389*T441*T344*(1-params(11))*params(3)*T354*exp(T354*y(23)))));
T1175 = y(36)*(-(T403*(T428*T390*T344*(1-params(11))*(1-params(3))*T354*exp(T354*y(23))+T366*T441*T344*(1-params(11))*(1-params(3))*T354*exp(T354*y(23)))));
T1230 = getPowerDeriv(T18,(-params(14)),2);
T1234 = T489*(-(params(9)*(T485+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),1+params(8),2))/(1+params(8))))+T488*T488*T1230;
T1250 = T507+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),1-params(3),2);
T1339 = y(37)*(-(T507*T389*T390*T344*(1-params(11))*params(3)*T354*exp(T354*y(23))+T368*T389*T440*T366*T507*T344*(1-params(11))*params(3)*T354*exp(T354*y(23))));
T1346 = y(36)*(-(T522*T366*T390*T344*(1-params(11))*(1-params(3))*T354*exp(T354*y(23))+T403*T366*T440*T366*T507*T344*(1-params(11))*(1-params(3))*T354*exp(T354*y(23))));
T1488 = getPowerDeriv(exp(y(31)-y(24)),params(5)-1,2);
  g1(1,1)=T21*exp(y(1))*exp(y(4))+T50;
  g1(1,4)=T21*exp(y(1))*exp(y(4));
  g1(1,11)=T33*y(43)*(-(exp(y(22))*exp(y(1))*exp(y(11))));
  g1(1,18)=exp(y(1))*exp(y(4))*T490;
  g1(1,19)=exp(y(1))*exp(y(4))*exp(y(19))*T489;
  g1(1,22)=T33*y(43)*(-(exp(y(22))*exp(y(1))*exp(y(11))))+T33*y(46)*(-(exp(y(1))*exp(y(22))));
  g1(1,35)=exp(y(1));
  g1(1,43)=T33*(-(exp(y(22))*exp(y(1))*exp(y(11))));
  g1(1,46)=T33*(-(exp(y(1))*exp(y(22))));
  g1(1,57)=(-1)+params(21);
  g1(2,2)=T21*(-exp(y(2)))+y(63)*(-T829)+exp(y(2))*y(39)+y(50)*(-(T73*params(4)*params(4)*exp(y(2)*params(4))))+params(21)*y(63)*T829;
  g1(2,3)=y(63)*(-T844)+params(21)*y(63)*T844;
  g1(2,18)=(-exp(y(2)))*T490;
  g1(2,19)=(-exp(y(2)))*exp(y(19))*T489;
  g1(2,39)=exp(y(2));
  g1(2,50)=(-(T73*params(4)*exp(y(2)*params(4))));
  g1(2,59)=(-1)+params(21);
  g1(2,63)=(-T64)+params(21)*T64;
  g1(3,2)=y(63)*(-T844)+params(21)*y(63)*T844;
  g1(3,3)=y(63)*(-T855)+y(49)*(-(T99*params(4)*params(4)*exp(y(3)*params(4))))+exp(y(3))*y(39)+y(45)*y(14)*T99*params(4)*(params(4)-1)*(params(4)-1)*exp(y(3)*(params(4)-1))+params(21)*y(63)*T855;
  g1(3,14)=y(45)*T99*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,39)=exp(y(3));
  g1(3,45)=y(14)*T99*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,49)=(-(T99*params(4)*exp(y(3)*params(4))));
  g1(3,58)=(-1)+params(21);
  g1(3,63)=(-T92)+params(21)*T92;
  g1(4,1)=T21*exp(y(1))*exp(y(4));
  g1(4,4)=T21*T137+y(64)*(-T878)+y(53)*(-exp(y(4)))+exp(y(4))*y(52)+params(21)*y(64)*T878;
  g1(4,5)=y(64)*(-T888)+params(21)*y(64)*T888;
  g1(4,18)=T137*T490;
  g1(4,19)=T137*exp(y(19))*T489;
  g1(4,24)=T21*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T661));
  g1(4,31)=T21*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T661));
  g1(4,52)=exp(y(4));
  g1(4,53)=(-exp(y(4)));
  g1(4,61)=(-1)+params(21);
  g1(4,64)=(-T143)+params(21)*T143;
  g1(5,4)=y(64)*(-T888)+params(21)*y(64)*T888;
  g1(5,5)=y(64)*(-T899)+y(53)*(-exp(y(5)))+exp(y(5))*y(51)+params(21)*y(64)*T899;
  g1(5,51)=exp(y(5));
  g1(5,53)=(-exp(y(5)));
  g1(5,60)=(-1)+params(21);
  g1(5,64)=(-T163)+params(21)*T163;
  g1(6,6)=T208;
  g1(6,10)=T272;
  g1(6,24)=params(21)*y(39)*exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))*(-params(5))+params(21)*y(48)*(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))))+params(21)*y(52)*(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))));
  g1(6,39)=params(21)*exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)));
  g1(6,48)=exp(y(6))+params(21)*(-(exp(y(6))*(1-exp((-y(24)))*exp(y(10)))));
  g1(6,52)=params(21)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(7,7)=T231;
  g1(7,11)=T908;
  g1(7,39)=params(21)*exp(y(7))*params(6)*exp(y(11)*params(5));
  g1(7,47)=exp(y(7))+params(21)*(-(exp(y(7))*(1-exp(y(11)))));
  g1(7,51)=params(21)*(-(exp(y(11))*exp(y(7))));
  g1(8,8)=y(50)*exp(y(8))+y(48)*(-(exp(y(8))*params(7)))+params(21)*y(50)*(-(exp(y(8))*(1-params(7))));
  g1(8,48)=(-(exp(y(8))*params(7)));
  g1(8,50)=exp(y(8))+params(21)*(-(exp(y(8))*(1-params(7))));
  g1(9,9)=y(49)*exp(y(9))+y(47)*(-(params(7)*exp(y(9))))+params(21)*y(49)*(-((1-params(7))*exp(y(9))));
  g1(9,47)=(-(params(7)*exp(y(9))));
  g1(9,49)=exp(y(9))+params(21)*(-((1-params(7))*exp(y(9))));
  g1(10,6)=T272;
  g1(10,10)=params(21)*y(56)*(-exp(y(10)))+params(21)*y(52)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))))+params(21)*y(48)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))))+params(21)*y(39)*exp(y(6))*params(6)*params(5)*params(5)*exp(params(5)*(y(10)-y(24)));
  g1(10,24)=params(21)*y(52)*(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))))+params(21)*y(48)*(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))))+params(21)*y(39)*exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(24)))*(-params(5));
  g1(10,39)=params(21)*exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(24)));
  g1(10,48)=params(21)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))));
  g1(10,52)=params(21)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(10,56)=params(21)*(-exp(y(10)));
  g1(11,1)=y(43)*(-(exp(y(22))*exp(y(1))*exp(y(11))));
  g1(11,7)=T908;
  g1(11,11)=params(21)*y(51)*(-(exp(y(11))*exp(y(7))))+params(21)*y(47)*(-(exp(y(7))*(-exp(y(11)))))+y(46)*exp(y(22))*params(6)*params(5)*(params(5)-1)*(params(5)-1)*exp(y(11)*(params(5)-1))+y(43)*(-(exp(y(22))*(exp(y(1))*exp(y(11))+y(13)*(-exp(y(11)))-params(6)*params(5)*params(5)*exp(y(11)*params(5)))))+params(21)*y(39)*exp(y(7))*params(6)*params(5)*params(5)*exp(y(11)*params(5));
  g1(11,13)=y(43)*(-(exp(y(22))*(-exp(y(11)))));
  g1(11,22)=y(46)*exp(y(22))*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T295;
  g1(11,39)=params(21)*exp(y(7))*params(6)*params(5)*exp(y(11)*params(5));
  g1(11,43)=T294;
  g1(11,46)=exp(y(22))*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1));
  g1(11,47)=params(21)*(-(exp(y(7))*(-exp(y(11)))));
  g1(11,51)=params(21)*(-(exp(y(11))*exp(y(7))));
  g1(12,12)=exp(y(12))*y(38);
  g1(12,38)=exp(y(12));
  g1(13,11)=T33*y(43)*(-(exp(y(22))*(-exp(y(11)))));
  g1(13,22)=T33*y(43)*(-(exp(y(22))*(1-exp(y(11)))))+T33*exp(y(22))*y(46);
  g1(13,43)=1+T33*(-(exp(y(22))*(1-exp(y(11)))));
  g1(13,44)=(-params(7));
  g1(13,46)=T33*exp(y(22));
  g1(14,3)=y(45)*T99*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(14,22)=T33*y(44)*(-(exp(y(22))*(1-params(7))));
  g1(14,44)=1+T33*(-(exp(y(22))*(1-params(7))));
  g1(14,45)=T99*params(4)*exp(y(3)*(params(4)-1));
  g1(15,15)=y(53)*exp(y(15))+y(35)*(-(params(11)*T344*(T348+exp(y(15))*exp(y(15))*getPowerDeriv(exp(y(15)),T346,2))))+y(34)*(-(T376*params(11)*(T356+exp(y(15))*exp(y(15))*getPowerDeriv(exp(y(15)),T354,2))+params(11)*T356*params(11)*T356*T966));
  g1(15,16)=y(35)*(-(T348*params(11)*T394));
  g1(15,17)=y(34)*(-(params(11)*T356*T432*T966));
  g1(15,18)=y(34)*(-(params(11)*T356*T528*T966));
  g1(15,23)=y(34)*(-(params(11)*T356*T643*T966));
  g1(15,34)=(-(params(11)*T356*T376));
  g1(15,35)=(-(params(11)*T344*T348));
  g1(15,53)=exp(y(15));
  g1(16,15)=y(35)*(-(T348*params(11)*T394));
  g1(16,16)=y(39)*(-exp(y(16)))+y(37)*(-(T368*T389*T390*exp(T354*y(23))*(1-params(11))*params(3)*T991))+y(36)*(-(T403*T366*T390*exp(T354*y(23))*(1-params(11))*(1-params(3))*T991))+exp(y(16))*y(34)+y(35)*(-(T412*params(11)*T991));
  g1(16,17)=T1018+T1026;
  g1(16,18)=T1043;
  g1(16,23)=T1056;
  g1(16,34)=exp(y(16));
  g1(16,35)=(-(T412*params(11)*T394));
  g1(16,36)=(-(T403*T366*T390*T394*exp(T354*y(23))*(1-params(11))*(1-params(3))));
  g1(16,37)=(-(T368*T389*T390*exp(T354*y(23))*(1-params(11))*params(3)*T394));
  g1(16,39)=(-exp(y(16)));
  g1(16,62)=(-1)+params(21);
  g1(17,15)=params(21)*y(34)*(-(T432*params(11)*T356*T966));
  g1(17,16)=params(21)*T1018+params(21)*T1026;
  g1(17,17)=y(39)*exp(y(17))+params(21)*y(39)*(-(exp(y(17))*(1-params(10))))+params(21)*y(34)*(-(T432*T432*T966+T376*(1-params(11))*exp(T354*y(23))*(T430*T368*T1065+T368*T428*T368*T428*T1067)))+params(21)*y(36)*(-(T403*(T390*T437*T1065+T428*T437*T441+T428*T437*T441+T366*T437*T1086)))+params(21)*y(37)*(-(T368*(T441*T450*T455+T389*T450*T1086+T441*T450*T455+T390*T450*(T455+exp(y(17))*exp(y(17))*getPowerDeriv(exp(y(17)),params(3)-1,2)))))+params(21)*y(38)*(-(exp(y(18)*(1-params(3)))*exp(T354*y(23))*params(3)*params(3)*exp(y(17)*params(3))));
  g1(17,18)=params(21)*y(34)*(-(T432*T528*T966+T376*(1-params(11))*exp(T354*y(23))*(T430*T428*T507+T368*T428*T366*T507*T1067)))+params(21)*y(36)*(-(T444*T522+T403*(T428*T437*T440*T366*T507+T366*T437*(T440*T428*T507+T368*T428*T366*T507*T1082))))+params(21)*y(37)*(-((T389*T441*T450+T390*T450*T455)*T507+T368*(T455*T450*T440*T366*T507+T389*T450*(T440*T428*T507+T368*T428*T366*T507*T1082))))+params(21)*y(38)*(-(exp(T354*y(23))*params(3)*exp(y(17)*params(3))*(1-params(3))*exp(y(18)*(1-params(3)))));
  g1(17,23)=params(21)*y(34)*(-(T376*T368*T428*T430*(1-params(11))*T354*exp(T354*y(23))+T432*T643*T966))+params(21)*T1175+params(21)*T1168+params(21)*y(38)*(-(exp(y(18)*(1-params(3)))*params(3)*exp(y(17)*params(3))*T354*exp(T354*y(23))));
  g1(17,34)=params(21)*(-(T376*T432));
  g1(17,36)=params(21)*(-(T403*T444));
  g1(17,37)=params(21)*T459;
  g1(17,38)=params(21)*(-(exp(y(18)*(1-params(3)))*exp(T354*y(23))*params(3)*exp(y(17)*params(3))));
  g1(17,39)=exp(y(17))+params(21)*(-(exp(y(17))*(1-params(10))));
  g1(18,1)=exp(y(1))*exp(y(4))*T490;
  g1(18,2)=(-exp(y(2)))*T490;
  g1(18,4)=T137*T490;
  g1(18,15)=y(34)*(-(T528*params(11)*T356*T966));
  g1(18,16)=T1043;
  g1(18,17)=y(38)*(-(exp(T354*y(23))*params(3)*exp(y(17)*params(3))*(1-params(3))*exp(y(18)*(1-params(3)))))+y(37)*(-((T389*T441*T450+T390*T450*T455)*T507+T368*(T455*T450*T440*T366*T507+T389*T450*(T366*T507*T368*T428*T1082+T440*T428*T507))))+y(36)*(-(T403*(T428*T437*T440*T366*T507+T366*T437*(T366*T507*T368*T428*T1082+T440*T428*T507))+T444*T522))+y(34)*(-(T528*T432*T966+T376*(1-params(11))*exp(T354*y(23))*(T366*T507*T368*T428*T1067+T430*T428*T507)));
  g1(18,18)=(T137-exp(y(2)))*T1234+y(42)*(-((T21*params(1)*T1234-T490*T490*params(1))/(T21*T21)))+exp(y(18))*y(40)+y(38)*(-(exp(T354*y(23))*exp(y(17)*params(3))*(1-params(3))*(1-params(3))*exp(y(18)*(1-params(3)))))+y(37)*(-(T507*T389*T450*T440*T366*T507+T389*T390*T450*T1250+T507*T389*T450*T440*T366*T507+T368*T389*T450*(T366*T507*T366*T507*T1082+T440*T366*T1250)))+y(36)*(-(T366*T437*T440*T366*T507*T522+T403*T366*T437*(T366*T507*T366*T507*T1082+T440*T366*T1250)+T366*T437*T440*T366*T507*T522+T366*T390*T437*(T522+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),(-params(3)),2))))+y(34)*(-(T528*T528*T966+T376*(1-params(11))*exp(T354*y(23))*(T366*T507*T366*T507*T1067+T430*T366*T1250)))+params(21)*y(42)*(-((T21*T21*(-(T490*T490*params(1)+T21*params(1)*T1234))-(-(T490*T21*params(1)))*(T21*T490+T21*T490))/(T21*T21*T21*T21)));
  g1(18,19)=(T137-exp(y(2)))*T488*exp(y(19))*T1230+y(42)*(-((T21*params(1)*T488*exp(y(19))*T1230-T490*params(1)*exp(y(19))*T489)/(T21*T21)))+params(21)*y(42)*(-((T21*T21*(-(T490*params(1)*exp(y(19))*T489+T21*params(1)*T488*exp(y(19))*T1230))-(-(T490*T21*params(1)))*(T21*exp(y(19))*T489+T21*exp(y(19))*T489))/(T21*T21*T21*T21)));
  g1(18,23)=y(38)*(-((1-params(3))*exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T354*exp(T354*y(23))))+T1339+T1346+y(34)*(-(T376*T430*T366*T507*(1-params(11))*T354*exp(T354*y(23))+T528*T643*T966));
  g1(18,24)=T490*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T661));
  g1(18,31)=T490*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T661));
  g1(18,34)=(-(T376*T528));
  g1(18,36)=(-(T403*T366*T437*T440*T366*T507+T366*T390*T437*T522));
  g1(18,37)=(-(T389*T390*T450*T507+T368*T389*T450*T440*T366*T507));
  g1(18,38)=T503;
  g1(18,40)=exp(y(18));
  g1(18,42)=(-(T490*params(1)/T21))+params(21)*(-((-(T490*T21*params(1)))/(T21*T21)));
  g1(19,1)=exp(y(1))*exp(y(4))*exp(y(19))*T489;
  g1(19,2)=(-exp(y(2)))*exp(y(19))*T489;
  g1(19,4)=T137*exp(y(19))*T489;
  g1(19,18)=(T137-exp(y(2)))*exp(y(19))*T488*T1230+y(42)*(-((T21*params(1)*exp(y(19))*T488*T1230-T490*params(1)*exp(y(19))*T489)/(T21*T21)))+params(21)*y(42)*(-((T21*T21*(-(T490*params(1)*exp(y(19))*T489+T21*params(1)*exp(y(19))*T488*T1230))-(-(T21*params(1)*exp(y(19))*T489))*(T21*T490+T21*T490))/(T21*T21*T21*T21)));
  g1(19,19)=(T137-exp(y(2)))*(exp(y(19))*T489+exp(y(19))*exp(y(19))*T1230)+y(42)*(-((T21*params(1)*(exp(y(19))*T489+exp(y(19))*exp(y(19))*T1230)-exp(y(19))*T489*params(1)*exp(y(19))*T489)/(T21*T21)))+exp(y(19))*y(39)+params(21)*y(42)*(-((T21*T21*(-(exp(y(19))*T489*params(1)*exp(y(19))*T489+T21*params(1)*(exp(y(19))*T489+exp(y(19))*exp(y(19))*T1230)))-(-(T21*params(1)*exp(y(19))*T489))*(T21*exp(y(19))*T489+T21*exp(y(19))*T489))/(T21*T21*T21*T21)));
  g1(19,24)=exp(y(19))*T489*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T661));
  g1(19,31)=exp(y(19))*T489*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T661));
  g1(19,39)=exp(y(19));
  g1(19,42)=(-(params(1)*exp(y(19))*T489/T21))+params(21)*(-((-(T21*params(1)*exp(y(19))*T489))/(T21*T21)));
  g1(20,20)=y(37)*exp(y(20))+T33*y(41)*(-(exp(y(22))*exp(y(20))));
  g1(20,22)=T33*y(41)*(-(exp(y(22))*exp(y(20))));
  g1(20,37)=exp(y(20));
  g1(20,41)=T33*(-(exp(y(22))*exp(y(20))));
  g1(21,21)=y(36)*exp(y(21))+y(40)*(-(T576*(T581+exp(y(21))*exp(y(21))*getPowerDeriv(exp(y(21)),1/params(8),2))));
  g1(21,36)=exp(y(21));
  g1(21,40)=(-(T576*T581));
  g1(22,1)=T33*y(43)*(-(exp(y(22))*exp(y(1))*exp(y(11))))+T33*y(46)*(-(exp(y(1))*exp(y(22))));
  g1(22,11)=T33*y(46)*exp(y(22))*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T33*T295;
  g1(22,13)=T33*y(43)*(-(exp(y(22))*(1-exp(y(11)))))+T33*exp(y(22))*y(46);
  g1(22,14)=T33*y(44)*(-(exp(y(22))*(1-params(7))));
  g1(22,20)=T33*y(41)*(-(exp(y(22))*exp(y(20))));
  g1(22,22)=T616;
  g1(22,41)=T33*(-(exp(y(22))*(1+exp(y(20))-params(10))));
  g1(22,42)=exp(y(22));
  g1(22,43)=T33*T607;
  g1(22,44)=T33*(-(y(14)*exp(y(22))*(1-params(7))));
  g1(22,46)=T33*T592;
  g1(23,15)=y(34)*(-(T643*params(11)*T356*T966));
  g1(23,16)=T1056;
  g1(23,17)=y(38)*(-(exp(y(18)*(1-params(3)))*params(3)*exp(y(17)*params(3))*T354*exp(T354*y(23))))+T1168+T1175+y(34)*(-(T643*T432*T966+T376*T368*T428*T430*(1-params(11))*T354*exp(T354*y(23))));
  g1(23,18)=y(38)*(-((1-params(3))*exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T354*exp(T354*y(23))))+T1339+T1346+y(34)*(-(T643*T528*T966+T376*T430*T366*T507*(1-params(11))*T354*exp(T354*y(23))));
  g1(23,23)=y(38)*(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T354*T354*exp(T354*y(23))))+y(37)*(-(T368*T389*T390*T344*(1-params(11))*params(3)*T354*T354*exp(T354*y(23))))+y(36)*(-(T403*T366*T390*T344*(1-params(11))*(1-params(3))*T354*T354*exp(T354*y(23))))+y(34)*(-(T643*T643*T966+T376*T370*(1-params(11))*T354*T354*exp(T354*y(23))));
  g1(23,34)=(-(T376*T643));
  g1(23,36)=(-(T403*T366*T390*T344*(1-params(11))*(1-params(3))*T354*exp(T354*y(23))));
  g1(23,37)=(-(T368*T389*T390*T344*(1-params(11))*params(3)*T354*exp(T354*y(23))));
  g1(23,38)=(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T354*exp(T354*y(23))));
  g1(23,55)=1+params(21)*(-params(15))+T650*(-params(16));
  g1(24,4)=T21*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T661));
  g1(24,6)=T683;
  g1(24,10)=y(52)*(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))))+y(48)*(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))))+y(39)*exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(24)))*(-params(5));
  g1(24,18)=T490*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T661));
  g1(24,19)=exp(y(19))*T489*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T661));
  g1(24,24)=T21*(-(exp(y(4))*params(6)*(exp(y(31)-y(24))*T661+(-exp(y(31)-y(24)))*(-exp(y(31)-y(24)))*T1488)))+y(52)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))))+y(48)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))))+y(39)*exp(y(6))*params(6)*(-params(5))*exp(params(5)*(y(10)-y(24)))*(-params(5));
  g1(24,31)=T21*(-(exp(y(4))*params(6)*((-exp(y(31)-y(24)))*T661+(-exp(y(31)-y(24)))*exp(y(31)-y(24))*T1488)));
  g1(24,39)=exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))*(-params(5));
  g1(24,48)=(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))));
  g1(24,52)=(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))));
  g1(24,54)=1;
  g1(25,57)=1;
  g1(26,58)=1;
  g1(27,59)=1;
  g1(28,60)=1;
  g1(29,61)=1;
  g1(30,62)=1;
  g1(31,4)=T21*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T661));
  g1(31,18)=T490*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T661));
  g1(31,19)=exp(y(19))*T489*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T661));
  g1(31,24)=T21*(-(exp(y(4))*params(6)*((-exp(y(31)-y(24)))*T661+exp(y(31)-y(24))*(-exp(y(31)-y(24)))*T1488)));
  g1(31,31)=y(56)*exp(y(31))+T21*(-(exp(y(4))*params(6)*(exp(y(31)-y(24))*T661+exp(y(31)-y(24))*exp(y(31)-y(24))*T1488)));
  g1(31,56)=exp(y(31));
  g1(32,63)=1;
  g1(33,64)=1;
  g1(34,15)=(-(params(11)*T356*T376));
  g1(34,16)=exp(y(16));
  g1(34,17)=(-(T376*T432));
  g1(34,18)=(-(T376*T528));
  g1(34,23)=(-(T376*T643));
  g1(35,1)=exp(y(1));
  g1(35,15)=(-(params(11)*T344*T348));
  g1(35,16)=(-(T412*params(11)*T394));
  g1(36,16)=(-(T403*T366*T390*T394*exp(T354*y(23))*(1-params(11))*(1-params(3))));
  g1(36,17)=(-(T403*T444));
  g1(36,18)=(-(T403*T366*T437*T440*T366*T507+T366*T390*T437*T522));
  g1(36,21)=exp(y(21));
  g1(36,23)=(-(T403*T366*T390*T344*(1-params(11))*(1-params(3))*T354*exp(T354*y(23))));
  g1(37,16)=(-(T368*T389*T390*exp(T354*y(23))*(1-params(11))*params(3)*T394));
  g1(37,17)=T459;
  g1(37,18)=(-(T389*T390*T450*T507+T368*T389*T450*T440*T366*T507));
  g1(37,20)=exp(y(20));
  g1(37,23)=(-(T368*T389*T390*T344*(1-params(11))*params(3)*T354*exp(T354*y(23))));
  g1(38,12)=exp(y(12));
  g1(38,17)=(-(exp(y(18)*(1-params(3)))*exp(T354*y(23))*params(3)*exp(y(17)*params(3))));
  g1(38,18)=T503;
  g1(38,23)=(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T354*exp(T354*y(23))));
  g1(39,2)=exp(y(2));
  g1(39,3)=exp(y(3));
  g1(39,6)=exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)));
  g1(39,7)=exp(y(7))*params(6)*exp(y(11)*params(5));
  g1(39,10)=exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(24)));
  g1(39,11)=exp(y(7))*params(6)*params(5)*exp(y(11)*params(5));
  g1(39,16)=(-exp(y(16)));
  g1(39,17)=exp(y(17))-exp(y(17))*(1-params(10));
  g1(39,19)=exp(y(19));
  g1(39,24)=exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))*(-params(5));
  g1(40,18)=exp(y(18));
  g1(40,21)=(-(T576*T581));
  g1(41,20)=(-(exp(y(22))*exp(y(20))));
  g1(41,22)=(-(exp(y(22))*(1+exp(y(20))-params(10))));
  g1(42,18)=(-((T21*T490*params(1)-T490*T21*params(1))/(T21*T21)));
  g1(42,19)=(-((T21*params(1)*exp(y(19))*T489-T21*params(1)*exp(y(19))*T489)/(T21*T21)));
  g1(42,22)=exp(y(22));
  g1(43,1)=(-(exp(y(22))*exp(y(1))*exp(y(11))));
  g1(43,11)=T294;
  g1(43,13)=1-exp(y(22))*(1-exp(y(11)));
  g1(43,22)=T607;
  g1(44,13)=(-params(7));
  g1(44,14)=1-exp(y(22))*(1-params(7));
  g1(44,22)=(-(y(14)*exp(y(22))*(1-params(7))));
  g1(45,3)=y(14)*T99*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(45,14)=T99*params(4)*exp(y(3)*(params(4)-1));
  g1(46,1)=(-(exp(y(1))*exp(y(22))));
  g1(46,11)=exp(y(22))*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1));
  g1(46,13)=exp(y(22));
  g1(46,22)=T592;
  g1(47,7)=exp(y(7))-exp(y(7))*(1-exp(y(11)));
  g1(47,9)=(-(params(7)*exp(y(9))));
  g1(47,11)=(-(exp(y(7))*(-exp(y(11)))));
  g1(48,6)=exp(y(6))-exp(y(6))*(1-exp((-y(24)))*exp(y(10)));
  g1(48,8)=(-(exp(y(8))*params(7)));
  g1(48,10)=(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))));
  g1(48,24)=(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))));
  g1(49,3)=(-(T99*params(4)*exp(y(3)*params(4))));
  g1(49,9)=exp(y(9))-(1-params(7))*exp(y(9));
  g1(50,2)=(-(T73*params(4)*exp(y(2)*params(4))));
  g1(50,8)=exp(y(8))-exp(y(8))*(1-params(7));
  g1(51,5)=exp(y(5));
  g1(51,7)=(-(exp(y(11))*exp(y(7))));
  g1(51,11)=(-(exp(y(11))*exp(y(7))));
  g1(52,4)=exp(y(4));
  g1(52,6)=(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(52,10)=(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(52,24)=(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))));
  g1(53,4)=(-exp(y(4)));
  g1(53,5)=(-exp(y(5)));
  g1(53,15)=exp(y(15));
  g1(54,24)=1;
  g1(55,23)=1-(params(15)+params(16));
  g1(56,10)=(-exp(y(10)));
  g1(56,31)=exp(y(31));
  g1(57,25)=1;
  g1(58,26)=1;
  g1(59,27)=1;
  g1(60,28)=1;
  g1(61,29)=1;
  g1(62,30)=1;
  g1(63,32)=1;
  g1(64,33)=1;
  g1(65,55)=(-1);
  g1(65,65)=1;
  g1(66,23)=(-1);
  g1(66,66)=1;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],66,4356);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],66,287496);
end
end
end
end
